/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Converter {
    File input_mei_File;
    static String filename;
    public static String filenameForNodes;
    public static String postfix_id;
    DocumentParser document_parser;
    NeoApi api;
    public static PrintWriter log;
    public static PrintWriter log_query;
    public static boolean is_first_measure;
    public static int numero_variable_id;
    public static NodeList instruments;
    public static boolean is_last_measure;
    public static HashMap<String, String> voices;
    public static HashMap<String, String> voices_instruments;
    public static HashMap<String, Event> last_event_voices;
    public static HashMap<String, Float> last_position_voices;
    public static String query;
    public static float meter_unit;

    static {
        is_first_measure = true;
        numero_variable_id = 0;
        is_last_measure = false;
        voices = new HashMap();
        voices_instruments = new HashMap();
        last_event_voices = new HashMap();
        last_position_voices = new HashMap();
        query = new String("");
    }

    public Converter(File inputxmlFile, Boolean connect, String port, String login, String password) throws SAXException, IOException, ParserConfigurationException {
        filename = inputxmlFile.getName().toString();
        filenameForNodes = filename.replace("-", "_").replace(".", "_").replace("_", "_");
        postfix_id = "_" + filenameForNodes;
        this.document_parser = new DocumentParser(inputxmlFile);
        this.document_parser.getDocument().getDocumentElement().normalize();
        if (connect.booleanValue()) {
            this.api = new NeoApi(port, login, password);
        }
    }

    public static void raz() {
        is_first_measure = true;
        numero_variable_id = 0;
        is_last_measure = false;
        voices.clear();
        voices_instruments.clear();
        last_event_voices.clear();
        last_position_voices.clear();
        query = new String("");
    }

    public File getInputxmlFile() {
        return this.input_mei_File;
    }

    public void setInputxmlFile(File inputxmlFile) {
        this.input_mei_File = inputxmlFile;
    }

    public DocumentParser getDocument_parser() {
        return this.document_parser;
    }

    public void setDocument_parser(DocumentParser document_parser) {
        this.document_parser = document_parser;
    }

    public static void print_log(String perpos, String str) {
        log.print("[" + perpos + "] " + str);
        log.flush();
    }

    public static void print_log_continuation(String perpos, String str) {
        log.print(str);
        log.flush();
    }

    public static void println_log_continuation(String perpos, String str) {
        log.println(str);
        log.flush();
    }

    public static void println_log(String perpos, String str) {
        log.print("[" + perpos + "] " + str + "\n");
        log.flush();
    }

    public static void addQ(String following) {
        query = String.valueOf(query) + following;
        log_query.print(following);
        log_query.flush();
    }

    public void create_score_hierachy() {
        Element scoreDef = this.getDocument_parser().getScoreDef();
        Node root_staff_grp = scoreDef.getElementsByTagName("staffGrp").item(0);
        Converter.addQ("CREATE (top" + postfix_id + ":TopRhythmic " + "{" + "inputfile: '" + filenameForNodes + "', " + "source:'" + filename + "'," + this.document_parser.metadataAsProperties() + "name: '" + "topRhythmic" + "'" + "})\n");
        this.extract_hierarchy_recursively(null, root_staff_grp, null);
    }

    private void extract_hierarchy_recursively(String parent, Node current_node, String instrument) {
        if (current_node.getNodeType() == 1) {
            String staff_id;
            Element current_elt = (Element)current_node;
            if (current_elt.hasAttribute("xml:id")) {
                staff_id = current_elt.getAttribute("xml:id").replace("-", "");
            } else {
                staff_id = "Staff" + numero_variable_id;
                ++numero_variable_id;
            }
            if (instrument == null) {
                if (current_elt.hasAttribute("label")) {
                    instrument = current_elt.getAttribute("label").replaceAll("[^a-zA-Z0-9]", " ").replace("'", "\\'");
                } else {
                    NodeList searchForLabel = current_elt.getChildNodes();
                    int indice_search = 0;
                    while (indice_search < searchForLabel.getLength()) {
                        Node current = searchForLabel.item(indice_search);
                        if (current.getNodeType() == 1 && ((Element)current).getNodeName() == "label") {
                            instrument = ((Element)current).getTextContent().replaceAll("[^a-zA-Z0-9]", " ").replace("'", "\\'");
                        }
                        ++indice_search;
                    }
                }
            }
            if (current_node.getNodeName() == "staffDef") {
                String voice_id = String.valueOf(current_elt.getAttribute("xml:id").replace("-", "")) + postfix_id;
                String mei_staff_id = current_elt.getAttribute("n");
                Converter.addQ("CREATE (" + voice_id + ":Voice " + "{inputfile: '" + filenameForNodes + "', source:'" + filename + "' ,id:'" + staff_id + "',name: '" + instrument + "', shape_clef:'" + current_elt.getAttribute("clef.shape") + "', staff_number:'" + mei_staff_id + "', line_clef:'" + current_elt.getAttribute("clef.line") + "'})\n");
                Converter.addQ("CREATE ((" + parent + ")-[:VOICE]->(" + voice_id + "))\n");
                Converter.addQ("CREATE ((" + voice_id + ")-[:RHYTHMIC]->(" + "top" + postfix_id + "))\n");
                voices.put(mei_staff_id, voice_id);
                voices_instruments.put(mei_staff_id, instrument);
                last_position_voices.put(mei_staff_id, Float.valueOf(0.0f));
            }
            if (current_node.getNodeName() == "staffGrp") {
                String group_id;
                if (current_elt.hasAttribute("xml:id")) {
                    group_id = String.valueOf(current_elt.getAttribute("xml:id").replace("-", "")) + postfix_id;
                } else {
                    group_id = "StaffGroup" + numero_variable_id + postfix_id;
                    ++numero_variable_id;
                }
                NodeList children = current_node.getChildNodes();
                if (instrument != null) {
                    Converter.addQ("CREATE (" + group_id + ":Score " + "{inputfile: '" + filenameForNodes + "', source:'" + filename + "'," + this.document_parser.metadataAsProperties() + "id:'" + group_id + "'," + "name: '" + instrument + "'" + "})\n");
                } else {
                    Converter.addQ("CREATE (" + group_id + ":Score " + "{inputfile: '" + filenameForNodes + "', source:'" + filename + "'," + this.document_parser.metadataAsProperties() + "id:'" + group_id + "'" + "})\n");
                }
                if (parent != null) {
                    Converter.addQ("CREATE ((" + parent + ")-[:CONTAINS]->(" + group_id + "))\n");
                }
                Converter.addQ("CREATE ((" + group_id + ")-[:RHYTHMIC]->(" + "top" + postfix_id + "))\n");
                int indice_child = 0;
                while (indice_child < children.getLength()) {
                    Node child = children.item(indice_child);
                    this.extract_hierarchy_recursively(group_id, child, instrument);
                    ++indice_child;
                }
            }
        }
    }

    public static NodeList getInstruments() {
        return instruments;
    }

    public static void setInstruments(NodeList instruments) {
        Converter.instruments = instruments;
    }

    public void create_measures_content() throws HandledException {
        Converter.print_log(this.getClass().toString(), "Get all the measures");
        NodeList nl = this.getDocument_parser().getMeasures();
        Converter.println_log_continuation(this.getClass().toString(), " (" + nl.getLength() + " measures)");
        Measure previousMeasure = null;
        int i = 0;
        while (i < nl.getLength()) {
            if (i == nl.getLength() - 1) {
                is_last_measure = true;
            }
            Node currentMeasure = nl.item(i);
            Converter.println_log(this.getClass().toString(), "Let's extract the content of the measure " + i);
            Measure m = new Measure(currentMeasure, this.api);
            m.create_measure();
            int indice_staff = 0;
            while (indice_staff < m.getStaves().getLength()) {
                Node currentStaff = m.getStaves().item(indice_staff);
                String mei_staff_id = ((Element)currentStaff).getAttribute("n");
                NodeList staves_of_the_current_staff = ((Element)currentStaff).getElementsByTagName("layer");
                int indice_layer = 0;
                while (indice_layer < staves_of_the_current_staff.getLength()) {
                    Node currentLayer = staves_of_the_current_staff.item(indice_layer);
                    String mei_layer_id = ((Element)currentLayer).getAttribute("n");
                    Converter.println_log(this.getClass().toString(), "Parsing measure " + m.getMei_id() + " / " + "staff " + mei_staff_id + " / " + "layer " + mei_layer_id);
                    Layer l = new Layer(currentLayer, this.api, mei_staff_id, mei_layer_id);
                    l.treat_layer(m, mei_staff_id, previousMeasure);
                    ++indice_layer;
                }
                ++indice_staff;
            }
            if (!is_first_measure) {
                m.link_to_previous_m(previousMeasure);
            }
            is_first_measure = false;
            previousMeasure = m;
            ++i;
        }
    }

    public void addTextToQuery(String subquery) {
        query = String.valueOf(query) + subquery;
    }
}

