/*
 * Decompiled with CFR 0.152.
 */
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Event {
    Node e;
    Element eElt;
    NodeList notes;
    NeoApi api;
    String mei_staff_id;
    String id_musypher;
    float duration;
    int dur;

    public float getDuration() {
        return this.duration;
    }

    public Event(Node event, String mei_staff_number, NeoApi a) {
        this.e = event;
        this.eElt = (Element)this.e;
        this.api = a;
        this.mei_staff_id = mei_staff_number;
        this.notes = this.eElt.getElementsByTagName("note");
        this.id_musypher = this.eElt.getAttribute("xml:id").replace("-", "");
        this.dur = Integer.parseInt(this.eElt.getAttribute("dur"));
        this.duration = 1.0f / (float)this.dur;
        if (this.eElt.getAttribute("dots") != "") {
            this.duration += this.duration / 2.0f;
        }
    }

    public String getId_musypher() {
        return this.id_musypher;
    }

    public void setId_musypher(String id_musypher) {
        this.id_musypher = id_musypher;
    }

    public void create_event() {
        Converter.print_log(this.getClass().toString(), "Create the event " + this.eElt.getAttribute("xml:id") + ", which is a " + this.eElt.getNodeName() + " of duration " + this.duration + " (dur: " + this.eElt.getAttribute("dur") + ")");
        float start = Converter.last_position_voices.get(this.mei_staff_id).floatValue();
        float end = Converter.last_position_voices.get(this.mei_staff_id).floatValue() + this.duration;
        Converter.addQ("CREATE (" + this.id_musypher + Converter.postfix_id + ":Event {inputfile: '" + Converter.filenameForNodes + "', source:'" + Converter.filename + "' ,id:'" + this.eElt.getAttribute("xml:id") + "' ,type: '" + this.eElt.getNodeName() + "' ,instrument:'" + Converter.voices_instruments.get(this.mei_staff_id) + "'" + ", dur: " + this.dur + ", duration:" + this.duration + ", pos:" + start + ", start:" + start + ", end:" + end + "}) \n");
        Converter.last_position_voices.put(this.mei_staff_id, Float.valueOf(end));
        if (this.eElt.getNodeName() == "chord") {
            Converter.println_log_continuation(this.getClass().toString(), " (treat chord case)");
            int i = 0;
            while (i < this.notes.getLength()) {
                if (this.notes.item(i).getNodeType() == 1) {
                    Element fact = (Element)this.notes.item(i);
                    Converter.println_log(this.getClass().toString(), "Create fact from the event and link them");
                    Converter.addQ("CREATE (event" + Converter.numero_variable_id + Converter.postfix_id + ":Fact {inputfile: '" + Converter.filenameForNodes + "', source:'" + Converter.filename + "', id: 'event" + Converter.numero_variable_id + "',type: '" + fact.getNodeName() + "',instrument:'" + Converter.voices_instruments.get(this.mei_staff_id) + "'}) \n");
                    Converter.addQ("CREATE ((" + this.id_musypher + Converter.postfix_id + ")-[:IS]->(" + "event" + Converter.numero_variable_id + Converter.postfix_id + "))\n");
                    ++Converter.numero_variable_id;
                }
                ++i;
            }
        } else {
            if (this.eElt.getNodeName() == "note") {
                Converter.println_log_continuation(this.getClass().toString(), " (treat note case)");
                String pname = this.eElt.getAttribute("pname");
                int octave = Integer.parseInt(this.eElt.getAttribute("oct"));
                String text_for_creation = "CREATE (fact" + Converter.numero_variable_id + Converter.postfix_id + ":Fact {inputfile: '" + Converter.filenameForNodes + "', source:'" + Converter.filename + "', id: 'fact" + Converter.numero_variable_id + "',type: '" + this.eElt.getNodeName() + "'" + ", pname:'" + pname + "'" + ", class:'" + pname + "'" + ", octave:" + octave + ", name:'" + pname.toUpperCase() + this.eElt.getAttribute("oct") + "'" + ", dur:" + this.eElt.getAttribute("dur") + ",instrument:'" + Converter.voices_instruments.get(this.mei_staff_id) + "'";
                String dots = this.eElt.getAttribute("dots");
                if (this.eElt.getAttribute("dots") != "") {
                    text_for_creation = String.valueOf(text_for_creation) + ", dots:'" + dots + "'";
                }
                String accid = this.eElt.getAttribute("accid");
                String accidgest = this.eElt.getAttribute("accid.ges");
                if (accid != "") {
                    text_for_creation = String.valueOf(text_for_creation) + ", accid:'" + accid + "'";
                }
                if (accidgest != "") {
                    text_for_creation = String.valueOf(text_for_creation) + ", accid_ges:'" + accidgest + "'";
                }
                text_for_creation = String.valueOf(text_for_creation) + ", halfTonesFromA4:" + Frequencies.halfTonesFromA4(pname.toUpperCase(), octave, accid, accidgest);
                text_for_creation = String.valueOf(text_for_creation) + ", halfTonesDiatonicFromA4:" + Frequencies.halfTonesFromA4Diatonic(pname.toUpperCase(), octave);
                text_for_creation = String.valueOf(text_for_creation) + ", alterationInTones:" + Frequencies.tonesFromAlteration(accid, accidgest);
                text_for_creation = String.valueOf(text_for_creation) + ", alterationInHalfTones:" + Frequencies.halfTonesFromAlteration(accid, accidgest);
                text_for_creation = String.valueOf(text_for_creation) + ", frequency:" + Frequencies.caculateFrequency(pname.toUpperCase(), octave, accid, accidgest);
                if (this.eElt.getFirstChild() != null && this.eElt.getFirstChild().getNextSibling().getNodeName() == "verse") {
                    Node verse = this.eElt.getFirstChild().getNextSibling();
                    Element verseElt = (Element)verse;
                    Node syl = verseElt.getFirstChild().getNextSibling();
                    Element sylElt = (Element)syl;
                    text_for_creation = String.valueOf(text_for_creation) + ", syllable:'" + sylElt.getTextContent().replaceAll("[^a-zA-Z0-9]", " ");
                }
                Converter.println_log(this.getClass().toString(), "Create fact from the event and link them");
                Converter.addQ(String.valueOf(text_for_creation) + "}) \n");
            } else if (this.eElt.getNodeName() == "rest") {
                Converter.println_log(this.getClass().toString(), "Create fact from the event");
                Converter.addQ("CREATE (fact" + Converter.numero_variable_id + Converter.postfix_id + ":Fact {inputfile: '" + Converter.filenameForNodes + "', source:'" + Converter.filename + "', id: 'fact" + Converter.numero_variable_id + "',type: '" + this.eElt.getNodeName() + "', dur:'" + this.eElt.getAttribute("dur") + "',instrument:'" + Converter.voices_instruments.get(this.mei_staff_id) + "'}) \n");
            } else {
                Converter.addQ("CREATE (fact" + Converter.numero_variable_id + Converter.postfix_id + ":Fact {inputfile: '" + Converter.filenameForNodes + "', source:'" + Converter.filename + "', id: 'fact" + Converter.numero_variable_id + "',type: '" + this.eElt.getNodeName() + "',instrument:'" + Converter.voices_instruments.get(this.mei_staff_id) + "'}) \n");
            }
            Converter.println_log(this.getClass().toString(), "link fact to its event");
            Converter.addQ("CREATE ((" + this.id_musypher + Converter.postfix_id + ")-[:IS]->(" + "fact" + Converter.numero_variable_id + Converter.postfix_id + "))\n");
            ++Converter.numero_variable_id;
        }
    }

    public void link_to_previous_event() throws HandledException {
        if (Converter.last_event_voices.containsKey(this.mei_staff_id)) {
            Event lastEvent = Converter.last_event_voices.get(this.mei_staff_id);
            Converter.println_log(this.getClass().toString(), "Link event " + this.geteElt().getAttribute("xml:id").replace("-", "") + " to the previous event which is : " + lastEvent.geteElt().getAttribute("xml:id").replace("-", "") + " with NEXT duration=" + this.duration);
            Converter.addQ("CREATE ((" + lastEvent.geteElt().getAttribute("xml:id").replace("-", "") + Converter.postfix_id + ")-[:NEXT {duration:" + lastEvent.getDuration() + "}]->(" + this.geteElt().getAttribute("xml:id").replace("-", "") + Converter.postfix_id + "))\n");
        } else {
            String voice_id = Converter.voices.get(this.mei_staff_id);
            Converter.println_log(this.getClass().toString(), "Link event to its voice");
            Converter.addQ("CREATE ((" + voice_id + ")-[:PLAYS]->(" + this.geteElt().getAttribute("xml:id").replace("-", "") + Converter.postfix_id + "))\n");
            Converter.addQ("CREATE ((" + voice_id + ")-[:timeSeries]->(" + this.geteElt().getAttribute("xml:id").replace("-", "") + Converter.postfix_id + "))\n");
        }
        Converter.last_event_voices.put(this.mei_staff_id, this);
    }

    public void treat_event(Measure m) throws HandledException {
        this.create_event();
        m.link_to_event(this);
        this.link_to_previous_event();
    }

    public void link_to_instrument(Node i) {
        Element iElt = (Element)i;
        Converter.println_log(this.getClass().toString(), "Link event to its instrument");
        Converter.addQ("CREATE ((" + iElt.getAttribute("xml:id").replace("-", "") + Converter.postfix_id + ")-[:PLAYS]->(" + this.geteElt().getAttribute("xml:id").replace("-", "") + Converter.postfix_id + "))\n");
        Converter.addQ("CREATE ((" + iElt.getAttribute("xml:id").replace("-", "") + Converter.postfix_id + ")-[:timeSeries]->(" + this.geteElt().getAttribute("xml:id").replace("-", "") + Converter.postfix_id + "))\n");
    }

    public Node getE() {
        return this.e;
    }

    public void setE(Node e) {
        this.e = e;
    }

    public NodeList getNotes() {
        return this.notes;
    }

    public void setNotes(NodeList notes) {
        this.notes = notes;
    }

    public Element geteElt() {
        return this.eElt;
    }

    public void seteElt(Element eElt) {
        this.eElt = eElt;
    }
}

