/*
 * Decompiled with CFR 0.152.
 */
public class Frequencies {
    public static float A4freq = 440.0f;

    public static float tonesFromAlteration(String alteration_str) {
        switch (alteration_str) {
            case "s": {
                return 0.5f;
            }
            case "f": {
                return -0.5f;
            }
            case "ss": {
                return 1.0f;
            }
            case "x": {
                return 1.0f;
            }
            case "ff": {
                return -1.0f;
            }
            case "xs": {
                return 1.5f;
            }
            case "sx": {
                return 1.5f;
            }
            case "tx": {
                return 1.5f;
            }
            case "tf": {
                return -1.5f;
            }
            case "n": {
                return 0.0f;
            }
            case "nf": {
                return -0.5f;
            }
            case "ns": {
                return 0.5f;
            }
            case "su": {
                return 0.75f;
            }
            case "sd": {
                return 0.25f;
            }
            case "fu": {
                return -0.25f;
            }
            case "fd": {
                return -0.75f;
            }
            case "nu": {
                return 0.25f;
            }
            case "nd": {
                return -0.25f;
            }
            case "1qf": {
                return -0.25f;
            }
            case "3qf": {
                return -0.75f;
            }
            case "1qs": {
                return 0.25f;
            }
            case "3qs": {
                return 0.75f;
            }
        }
        return 0.0f;
    }

    public static float tonesFromAlteration(String alteration_str1, String alteration_str2) {
        return Frequencies.tonesFromAlteration(alteration_str1) + Frequencies.tonesFromAlteration(alteration_str2);
    }

    public static float halfTonesFromAlteration(String alteration_str) {
        return 2.0f * Frequencies.tonesFromAlteration(alteration_str);
    }

    public static float halfTonesFromAlteration(String alteration_str1, String alteration_str2) {
        return 2.0f * Frequencies.tonesFromAlteration(alteration_str1, alteration_str2);
    }

    public static float halfTonesFromA4(String pname, int octave, String alteration_str) {
        return Frequencies.halfTonesFromA4Diatonic(pname, octave) + Frequencies.halfTonesFromAlteration(alteration_str);
    }

    public static float halfTonesFromA4(String pname, int octave, String alteration_str1, String alteration_str2) {
        return Frequencies.halfTonesFromA4Diatonic(pname, octave) + Frequencies.halfTonesFromAlteration(alteration_str1, alteration_str2);
    }

    public static double caculateFrequency(String pname, int octave, String alteration_str) {
        double ratio = Math.pow(2.0, 0.0833333358168602);
        float halftones = Frequencies.halfTonesFromA4(pname, octave, alteration_str);
        double exact_frequency = 440.0 * Math.pow(ratio, halftones);
        double frequency = (double)Math.round(exact_frequency * 100.0) / 100.0;
        return frequency;
    }

    public static double caculateFrequency(String pname, int octave, String alteration_str1, String alteration_str2) {
        double ratio = Math.pow(2.0, 0.0833333358168602);
        float halftones = Frequencies.halfTonesFromA4(pname, octave, alteration_str1, alteration_str2);
        double exact_frequency = 440.0 * Math.pow(ratio, halftones);
        double frequency = (double)Math.round(exact_frequency * 100.0) / 100.0;
        return frequency;
    }

    private static float halfTonesDistanceAfterA4Diatonic(String pname) {
        switch (pname) {
            case "A": {
                return 0.0f;
            }
            case "B": {
                return 2.0f;
            }
            case "C": {
                return 3.0f;
            }
            case "D": {
                return 5.0f;
            }
            case "E": {
                return 7.0f;
            }
            case "F": {
                return 8.0f;
            }
            case "G": {
                return 10.0f;
            }
        }
        return 0.0f;
    }

    private static float halfTonesDistanceBeforeA4(String pname) {
        switch (pname) {
            case "A": {
                return 0.0f;
            }
            case "B": {
                return 10.0f;
            }
            case "C": {
                return 9.0f;
            }
            case "D": {
                return 7.0f;
            }
            case "E": {
                return 5.0f;
            }
            case "F": {
                return 4.0f;
            }
            case "G": {
                return 2.0f;
            }
        }
        return 0.0f;
    }

    private static boolean isBeforeA4(String pname, int octave) {
        return octave <= 4 && (octave != 4 || pname != "B");
    }

    private static float halfTonesDistanceFromA4(String pname) {
        if (pname == "B") {
            return Frequencies.halfTonesDistanceAfterA4Diatonic(pname);
        }
        return Frequencies.halfTonesDistanceBeforeA4(pname);
    }

    public static float halfTonesFromA4Diatonic(String pname, int octave) {
        if (pname == "A" & octave == 4) {
            return 0.0f;
        }
        float tones = 0.0f;
        if (Frequencies.isBeforeA4(pname, octave)) {
            if (octave < 4) {
                tones = pname != "B" ? (float)(-12 * (4 - octave)) : (float)(-12 * (4 - octave - 1));
            }
            tones -= Frequencies.halfTonesDistanceBeforeA4(pname);
        } else {
            if (pname == "B" && octave == 4) {
                return 2.0f;
            }
            if (octave > 4) {
                tones = pname != "C" && pname != "D" && pname != "E" && pname != "F" && pname != "G" ? (float)(12 * (octave - 4)) : (float)(12 * (octave - 4 - 1));
            }
            tones += Frequencies.halfTonesDistanceAfterA4Diatonic(pname);
        }
        return tones;
    }
}

