/*
 * Decompiled with CFR 0.152.
 */
import java.util.List;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.TransactionWork;

public class NeoApi
implements AutoCloseable {
    private final Driver driver;
    private String uri;

    public NeoApi(String uri, String user, String password) {
        this.driver = GraphDatabase.driver(uri, AuthTokens.basic(user, password));
        this.uri = uri;
    }

    @Override
    public void close() throws Exception {
        this.driver.close();
    }

    public List<Record> match(String query) {
        Result result = this.driver.session().run(query);
        return result.list();
    }

    public void query(final String query) throws HandledException {
        TransactionWork<String> work = new TransactionWork<String>(){

            @Override
            public String execute(Transaction tx) {
                Result result = tx.run(query);
                return "done";
            }
        };
        Session session = this.driver.session();
        try {
            session.writeTransaction(work);
        }
        catch (Exception e) {
            throw new HandledException("DATABASE_EXCEPTION", "Failed to connect to populate the database " + this.uri, e);
        }
    }
}

