/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DocumentParser {
    public Document document;
    public HashMap<String, ArrayList<String>> metadata = new HashMap();

    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public DocumentParser(File inputxmlFile) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setExpandEntityReferences(false);
        factory.setValidating(false);
        DocumentBuilder dBuilder = factory.newDocumentBuilder();
        dBuilder.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                return new InputSource(new StringReader(""));
            }
        });
        this.document = dBuilder.parse(inputxmlFile);
        this.getMetadata();
    }

    public NodeList getInstruments() {
        NodeList instruments_list = this.document.getElementsByTagName("staffDef");
        return instruments_list;
    }

    public NodeList getStaffGrpList() {
        NodeList staffGrp_list = this.document.getElementsByTagName("staffGrp");
        return staffGrp_list;
    }

    public NodeList getMeasures() {
        NodeList measures_list = this.document.getElementsByTagName("measure");
        return measures_list;
    }

    public NodeList getLayers() {
        NodeList layers_list = this.document.getElementsByTagName("layer");
        return layers_list;
    }

    public int getNumberOfFacts() {
        NodeList notes_list = this.document.getElementsByTagName("note");
        NodeList rests_list = this.document.getElementsByTagName("rest");
        NodeList mRests_list = this.document.getElementsByTagName("mRest");
        NodeList chords_list = this.document.getElementsByTagName("chord");
        return notes_list.getLength() + rests_list.getLength() + mRests_list.getLength() + chords_list.getLength();
    }

    public Element getScoreDef() {
        Node scoreDef = this.document.getElementsByTagName("scoreDef").item(0);
        Element scoreDefElt = (Element)scoreDef;
        return scoreDefElt;
    }

    public void printMetadata() {
        System.out.print("Metadata :");
        for (String key : this.metadata.keySet()) {
            System.out.print("(" + key + " [");
            ArrayList<String> values = this.metadata.get(key);
            int i = 0;
            while (i < values.size()) {
                System.out.print(values.get(i));
                if (i < values.size() - 1) {
                    System.out.print(",");
                }
                ++i;
            }
            System.out.print("]),");
        }
        System.out.println("");
    }

    private void addmetadata(String key, String entry) {
        if (this.metadata.containsKey(key)) {
            this.metadata.get(key).add(entry);
        } else {
            ArrayList<String> newList = new ArrayList<String>();
            newList.add(entry.replace("'", "\\'"));
            this.metadata.put(key, newList);
        }
    }

    private void getMetadata() {
        NodeList composers = this.document.getElementsByTagName("composer");
        int indice = 0;
        while (indice < composers.getLength()) {
            Element current = (Element)composers.item(indice);
            this.addmetadata("composer", current.getTextContent());
            ++indice;
        }
        NodeList lyricists = this.document.getElementsByTagName("lyricist");
        int indice2 = 0;
        while (indice2 < lyricists.getLength()) {
            Element current = (Element)lyricists.item(indice2);
            this.addmetadata("lyricist", current.getTextContent());
            ++indice2;
        }
        NodeList rolesPersName = this.document.getElementsByTagName("persName");
        int indice3 = 0;
        while (indice3 < rolesPersName.getLength()) {
            Element current = (Element)rolesPersName.item(indice3);
            this.addmetadata(current.getAttribute("role").toString(), current.getTextContent());
            ++indice3;
        }
    }

    public String metadataAsProperties() {
        String properties = "";
        for (String key : this.metadata.keySet()) {
            properties = String.valueOf(properties) + key + ":" + "'";
            ArrayList<String> values = this.metadata.get(key);
            int i = 0;
            while (i < values.size()) {
                if (i > 0) {
                    properties = String.valueOf(properties) + " and ";
                }
                properties = String.valueOf(properties) + values.get(i);
                ++i;
            }
            properties = String.valueOf(properties) + "', ";
        }
        return properties;
    }
}

