/*
 * Decompiled with CFR 0.152.
 */
import java.util.HashSet;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Layer {
    Node l;
    NeoApi api;
    String mei_staff_id;
    String mei_layer_id;
    Element lElt;
    NodeList events;

    public Layer(Node layer, NeoApi a, String mei_staff_id_in, String mei_layer_id_in) {
        this.l = layer;
        this.lElt = (Element)this.l;
        this.mei_staff_id = mei_staff_id_in;
        this.mei_layer_id = mei_layer_id_in;
        this.events = this.lElt.getChildNodes();
        HashSet<Node> removable = new HashSet<Node>();
        int i = 0;
        while (i < this.events.getLength()) {
            Node e = this.events.item(i);
            Boolean tagged = false;
            if (e.getNodeType() != 1) {
                removable.add(e);
                tagged = true;
            }
            if (e.getNodeType() == 1 && (e.getNodeName() != "note" && e.getNodeName() != "beam" || e.getNodeName() == "note" && ((Element)e).hasAttribute("grace"))) {
                removable.add(e);
                tagged = true;
            }
            ++i;
        }
        for (Node e : removable) {
            if (e.getNodeType() == 1) {
                Converter.println_log(this.getClass().toString(), "Ignored : " + e.getNodeName() + " of mei id " + ((Element)e).getAttribute("xml:id"));
            } else {
                Converter.println_log(this.getClass().toString(), "Ignored : " + e.getNodeName());
            }
            e.getParentNode().removeChild(e);
        }
        this.api = a;
    }

    public void treat_layer(Measure m, String mei_staff_number, Measure last_m) throws HandledException {
        int w = 0;
        while (w < this.getEvents().getLength()) {
            if (this.getEvents().item(w).getNodeType() == 1) {
                Node currentEvent = this.getEvents().item(w);
                if (currentEvent.getNodeName() != "beam") {
                    Converter.println_log(this.getClass().toString(), "Instantiate Event");
                    Event e = new Event(currentEvent, mei_staff_number, this.api);
                    e.treat_event(m);
                } else {
                    Beam b = new Beam(currentEvent);
                    Converter.println_log(this.getClass().toString(), "Instantiate Beam (node type: " + currentEvent.getNodeName() + ")");
                    int x = 0;
                    while (x < b.getEvents().getLength()) {
                        Converter.println_log(this.getClass().toString(), "Element " + x + " is a " + b.getEvents().item(x).getNodeName());
                        if (b.getEvents().item(x).getNodeType() == 1) {
                            Converter.println_log(this.getClass().toString(), String.valueOf(x) + "e note du beam ");
                            Node currentNote = b.getEvents().item(x);
                            Event e = new Event(currentNote, mei_staff_number, this.api);
                            e.treat_event(m);
                        }
                        ++x;
                    }
                }
            }
            ++w;
        }
        if (Converter.is_last_measure) {
            this.link_to_end();
        }
    }

    public void link_to_end() {
        Converter.println_log(this.getClass().toString(), "Create the END Event and link for the staff " + this.mei_staff_id);
        Event last_event_id = Converter.last_event_voices.get(this.mei_staff_id);
        String instrument = Converter.voices_instruments.get(this.mei_staff_id);
        Converter.addQ("CREATE (END" + Integer.toString(Converter.numero_variable_id) + Converter.postfix_id + ":Event {id:'" + "END" + Integer.toString(Converter.numero_variable_id) + "',inputfile: '" + Converter.filenameForNodes + "', source:'" + Converter.filename + "',instrument:'" + instrument + "',type: 'END'}) \n");
        Converter.addQ("CREATE ((" + last_event_id.getId_musypher() + Converter.postfix_id + ")-[:NEXT]->(" + "END" + Integer.toString(Converter.numero_variable_id) + Converter.postfix_id + "))\n");
        ++Converter.numero_variable_id;
    }

    public Element getlElt() {
        return this.lElt;
    }

    public void setlElt(Element lElt) {
        this.lElt = lElt;
    }

    public Node getL() {
        return this.l;
    }

    public void setL(Node l) {
        this.l = l;
    }

    public NodeList getEvents() {
        return this.events;
    }

    public void setEvents(NodeList events) {
        this.events = events;
    }
}

