/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class Musypher
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    JButton choose_inputfileFS_button;
    JButton choose_inputfileURL_button;
    JButton testConNeo4jButton;
    JButton populateNeo4jButton;
    JButton createDumpButton;
    JTextArea log;
    JTextArea login;
    JTextArea password;
    JTextArea port;
    JTextArea input_file_print;
    JTextArea urlinputfile;
    JFileChooser fc;
    JFileChooser fcRepo;
    String stage1Text;
    JLabel label_input_file;
    TypeInputFile modeInputfile = TypeInputFile.NONE;
    static File input_MEI_file;
    static PrintWriter out;
    static Converter c;
    String textAbout = "Musypher prototype Beta Version 6 \n\nConverts the music score from a MEI fileinto a Cypher dump in order to produce a graph representation of the music score.\n\nIRISA/Shaman Team\n";

    public Musypher() {
        super("Musypher");
        this.setDefaultCloseOperation(3);
        this.setVisible(true);
        this.setResizable(true);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenuItem about = new JMenuItem(new AbstractAction("About"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent ae) {
                JFrame pop = new JFrame("About");
                JTextArea text = new JTextArea();
                text.setText(Musypher.this.textAbout);
                text.setLineWrap(true);
                text.setWrapStyleWord(true);
                text.setEditable(false);
                pop.setSize(300, 200);
                pop.add(text);
                pop.setDefaultCloseOperation(2);
                pop.setVisible(true);
            }
        });
        menuBar.add(about);
        this.log = new JTextArea(5, 50);
        this.log.setMargin(new Insets(5, 5, 5, 5));
        this.log.setEditable(false);
        this.fc = new JFileChooser();
        this.fc.setCurrentDirectory(new File("."));
        this.fc.addChoosableFileFilter(new FileNameExtensionFilter("MEI files", "mei"));
        this.fc.setAcceptAllFileFilterUsed(true);
        this.fcRepo = new JFileChooser();
        this.fcRepo.setCurrentDirectory(new File("."));
        this.fcRepo.setFileSelectionMode(1);
        JPanel input_file_panel = new JPanel(new GridLayout(4, 1, 0, 0));
        JPanel invit_input_file = new JPanel(new FlowLayout(0));
        this.stage1Text = "Stage 1- Choose a MEI input file ";
        this.label_input_file = new JLabel(this.stage1Text);
        this.label_input_file.setText(String.valueOf(this.stage1Text) + "(STATUS: no file selected)");
        invit_input_file.add(this.label_input_file);
        input_file_panel.add(invit_input_file);
        JPanel modeInputFS = new JPanel(new FlowLayout(0));
        JLabel label_input_fileFS = new JLabel("    * Either choose a file on the file system: ");
        modeInputFS.add(label_input_fileFS);
        this.choose_inputfileFS_button = new JButton("Choose a MEI file on the file system");
        this.choose_inputfileFS_button.addActionListener(this);
        modeInputFS.add(this.choose_inputfileFS_button);
        input_file_panel.add(modeInputFS);
        JPanel modeInputURL1 = new JPanel(new FlowLayout(0));
        JLabel label_input_fileURL = new JLabel("    * Or choose a file from an URL: ");
        modeInputURL1.add(label_input_fileURL);
        input_file_panel.add(modeInputURL1);
        JPanel modeInputURL2 = new JPanel(new FlowLayout(0));
        JLabel label_indent = new JLabel("      ");
        modeInputURL2.add(label_indent);
        this.urlinputfile = new JTextArea("http://neuma.huma-num.fr/media/corpora/all/composers/bach/chorals/bwv361/mei.xml");
        modeInputURL2.add(this.urlinputfile);
        this.choose_inputfileURL_button = new JButton("Validate (use this URL)");
        this.choose_inputfileURL_button.addActionListener(this);
        modeInputURL2.add(this.choose_inputfileURL_button);
        input_file_panel.add(modeInputURL2);
        this.getContentPane().add(input_file_panel);
        JPanel invitexport = new JPanel(new FlowLayout(0));
        JLabel labelexport = new JLabel("Stage 2- Export (either populate a Neo4J database, or print a dump file).");
        invitexport.add(labelexport);
        invitexport.setBackground(Color.gray);
        this.getContentPane().add(invitexport);
        JPanel modePopulateDBText = new JPanel(new FlowLayout(0));
        modePopulateDBText.add(new JLabel("In order to populate a Neo4j database: "));
        this.login = new JTextArea("neo4j");
        this.password = new JTextArea("root");
        this.port = new JTextArea("11005");
        JPanel populate_db_panel = new JPanel();
        populate_db_panel.setLayout(new GridLayout(6, 2));
        JPanel loginPanel = new JPanel(new FlowLayout(0));
        loginPanel.add(new JLabel("login : "));
        loginPanel.add(this.login);
        JPanel pwdPanel = new JPanel(new FlowLayout(0));
        pwdPanel.add(new JLabel("password : "));
        pwdPanel.add(this.password);
        JPanel portPanel = new JPanel(new FlowLayout(0));
        portPanel.add(new JLabel("Port : "));
        portPanel.add(this.port);
        populate_db_panel.add(modePopulateDBText);
        populate_db_panel.add(loginPanel);
        populate_db_panel.add(pwdPanel);
        populate_db_panel.add(portPanel);
        this.testConNeo4jButton = new JButton("Test the database connexion");
        this.testConNeo4jButton.addActionListener(this);
        populate_db_panel.add(this.testConNeo4jButton);
        this.populateNeo4jButton = new JButton("Go populate the above database");
        this.populateNeo4jButton.addActionListener(this);
        populate_db_panel.add(this.populateNeo4jButton);
        JPanel dump_panel = new JPanel();
        dump_panel.setLayout(new GridLayout(4, 1));
        JPanel modeDumpText1 = new JPanel(new FlowLayout(0));
        modeDumpText1.add(new JLabel("In order to create a dump file only:"));
        dump_panel.add(modeDumpText1);
        JPanel modeDumpText2 = new JPanel(new FlowLayout(0));
        modeDumpText2.add(new JLabel("No configuration is needed."));
        dump_panel.add(modeDumpText2);
        JPanel modeDumpText3 = new JPanel(new FlowLayout(0));
        modeDumpText3.add(new JLabel("The dump file will be written on the filesystem."));
        dump_panel.add(modeDumpText3);
        this.createDumpButton = new JButton("Go create a dump file");
        this.createDumpButton.addActionListener(this);
        dump_panel.add(this.createDumpButton);
        JPanel separation_panel = new JPanel();
        JPanel sepText = new JPanel(new FlowLayout(0));
        separation_panel.setBackground(Color.gray);
        sepText.setBackground(Color.gray);
        sepText.add(new JLabel("OR"));
        separation_panel.add(sepText);
        JPanel neo4j_or_dump = new JPanel(new FlowLayout(1));
        neo4j_or_dump.add(populate_db_panel);
        neo4j_or_dump.add(separation_panel);
        neo4j_or_dump.add((Component)dump_panel, "North");
        neo4j_or_dump.setBackground(Color.gray);
        this.getContentPane().add(neo4j_or_dump);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int returnVal;
        if (e.getSource() == this.choose_inputfileFS_button && (returnVal = this.fc.showOpenDialog(this)) == 0) {
            input_MEI_file = this.fc.getSelectedFile();
            try {
                Converter.log = new PrintWriter("log.txt");
                Converter.log_query = new PrintWriter("log_query.txt");
            }
            catch (FileNotFoundException e2) {
                e2.printStackTrace();
            }
            this.label_input_file.setText(String.valueOf(this.stage1Text) + "(STATUS: The input MEI file is " + input_MEI_file.getName() + " (file system))");
            this.modeInputfile = TypeInputFile.FS;
        }
        if (e.getSource() == this.choose_inputfileURL_button) {
            String url_string = this.urlinputfile.getText();
            try {
                URL url = new URL(url_string);
                try {
                    int len;
                    URLConnection connection = url.openConnection();
                    InputStream in = connection.getInputStream();
                    input_MEI_file = new File("_mei_from_url.mei");
                    FileOutputStream fos = new FileOutputStream(input_MEI_file);
                    byte[] buf = new byte[512];
                    while ((len = in.read(buf)) != -1) {
                        fos.write(buf, 0, len);
                    }
                    in.close();
                    fos.flush();
                    fos.close();
                    this.label_input_file.setText(String.valueOf(this.stage1Text) + "(STATUS: The input MEI file is " + this.urlinputfile.getText() + " (URL))");
                    this.modeInputfile = TypeInputFile.URL;
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            catch (MalformedURLException e1) {
                e1.printStackTrace();
            }
        }
        if (e.getSource() == this.testConNeo4jButton) {
            Boolean testConn = true;
            NeoApi apitest = new NeoApi("bolt://localhost:" + this.port.getText(), this.login.getText(), this.password.getText());
            try {
                apitest.query("MATCH (n) RETURN n LIMIT 1;");
            }
            catch (HandledException e2) {
                testConn = false;
                JOptionPane.showMessageDialog(this.getContentPane(), "Failed to populate the database " + e2.getMessage() + "\n");
                e2.printStackTrace();
            }
            if (testConn.booleanValue()) {
                JOptionPane.showMessageDialog(this.getContentPane(), "Successfull connexion to database bolt://localhost:" + this.port.getText());
            }
            try {
                apitest.close();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        if (e.getSource() == this.populateNeo4jButton) {
            if (this.modeInputfile == TypeInputFile.NONE) {
                JOptionPane.showMessageDialog(this.getContentPane(), "You must select de input MEI file before.", "Input MEI file missing", 2);
            } else {
                Musypher.open_new_log_files();
                try {
                    Converter.println_log_continuation(this.getClass().toString(), "");
                    Converter.println_log(this.getClass().toString(), "Instantiating the converter in order to send the dump file to the database");
                    c = new Converter(input_MEI_file, true, "bolt://localhost:" + this.port.getText(), this.login.getText(), this.password.getText());
                    Musypher.create_dump_query();
                    String nameDumpFile = "dump.cypher";
                    Musypher.write_query_in_file_query(nameDumpFile);
                    Converter.println_log(this.getClass().toString(), "Sending the query to the database");
                    Musypher.c.api.query(Converter.query);
                    Converter.raz();
                    Musypher.close_file_query();
                }
                catch (IOException | ParserConfigurationException | SAXException e1) {
                    JOptionPane.showMessageDialog(this.getContentPane(), "Failed to send " + input_MEI_file.getName().toString() + "  to database, see log.txt file");
                    e1.printStackTrace();
                }
                catch (HandledException e2) {
                    JOptionPane.showMessageDialog(this.getContentPane(), "Failed to populate the database " + e2.getMessage());
                    e2.printStackTrace();
                }
                JOptionPane.showMessageDialog(this.getContentPane(), "Graph based modelling of " + input_MEI_file.getName().toString() + " sent to Neo4j database (port " + this.port.getText() + ")");
            }
            this.log.setCaretPosition(this.log.getDocument().getLength());
        }
        if (e.getSource() == this.createDumpButton) {
            if (this.modeInputfile == TypeInputFile.NONE) {
                JOptionPane.showMessageDialog(this.getContentPane(), "You must select de input MEI file before.", "Input MEI file missing", 2);
            } else {
                Musypher.open_new_log_files();
                try {
                    Converter.println_log_continuation(this.getClass().toString(), "");
                    Converter.println_log(this.getClass().toString(), "Instantiating the converter in order to write a dump file");
                    c = new Converter(input_MEI_file, false, null, null, null);
                    Musypher.create_dump_query();
                    String nameDumpFile = "dump_" + input_MEI_file.getName().substring(0, input_MEI_file.getName().lastIndexOf(".")) + ".cypher";
                    Musypher.write_query_in_file_query(nameDumpFile);
                    Converter.raz();
                    Musypher.close_file_query();
                    JOptionPane.showMessageDialog(this.getContentPane(), "Cypher dump for propulate the graph based modelling of " + input_MEI_file.getName().toString() + " written on file " + nameDumpFile);
                }
                catch (IOException | ParserConfigurationException | SAXException e1) {
                    JOptionPane.showMessageDialog(this.getContentPane(), "Failed to Parse: " + e1.getMessage());
                    e1.printStackTrace();
                }
                catch (HandledException e2) {
                    JOptionPane.showMessageDialog(this.getContentPane(), "Failed to Parse: " + e2.getMessage());
                    e2.printStackTrace();
                }
            }
            this.log.setCaretPosition(this.log.getDocument().getLength());
        }
    }

    public static void open_new_log_files() {
        try {
            Converter.log = new PrintWriter("log.txt");
            Converter.log_query = new PrintWriter("log_query.txt");
        }
        catch (FileNotFoundException e2) {
            e2.printStackTrace();
        }
        Converter.println_log_continuation("Musypher", "");
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy/MM/dd\u00a0HH:mm:ss");
        LocalDateTime now = LocalDateTime.now();
        Converter.println_log("Musypher", "Log of the transcription of " + input_MEI_file + " at " + dtf.format(now));
        Converter.println_log_continuation("Musypher", "");
    }

    public static void write_query_in_file_query(String fileName) throws FileNotFoundException {
        Converter.println_log("Musypher", "Writing the query in the file " + fileName);
        out = new PrintWriter(fileName);
        out.println(String.valueOf(Converter.query) + ";");
    }

    public static void close_file_query() {
        out.close();
    }

    public static void create_dump_query() throws HandledException {
        Converter.println_log_continuation("Musypher", "");
        Converter.println_log("Musypher", "Creating the dump file. Stage 1/2 - Create the hierarchy of staffsgroups (i.e. the Scores end Voices nodes)");
        c.create_score_hierachy();
        Converter.println_log("Musypher", "Voices that were created :");
        for (String name : Converter.voices.keySet()) {
            String key = name.toString();
            String value = Converter.voices.get(name).toString();
            Converter.print_log_continuation("Musypher", String.valueOf(key) + " " + value + ",  ");
        }
        Converter.println_log_continuation("Musypher", "");
        Converter.println_log("Musypher", "Creating the dump file. Stage 2/2 -  About to create and browse measures");
        c.create_measures_content();
        System.out.println("The cypher dump is:");
        System.out.println(String.valueOf(Converter.query) + ";");
    }

    public static void main(String[] args) throws Exception, SAXException, IOException {
        if (args.length == 0) {
            new Musypher();
        } else {
            int i = 0;
            while (i < args.length) {
                System.out.println("Argument " + i + ": " + args[i]);
                ++i;
            }
            input_MEI_file = new File(args[0]);
            System.out.println("Command line: input_MEI_filename: " + input_MEI_file.getAbsolutePath());
            try {
                Converter.log = new PrintWriter("log.txt");
                Converter.log_query = new PrintWriter("log_query.txt");
            }
            catch (FileNotFoundException e2) {
                e2.printStackTrace();
            }
            Musypher.open_new_log_files();
            try {
                Converter.println_log_continuation("Musypher", "");
                Converter.println_log("Musypher", "Instantiating the converter in order to write a dump file");
                c = new Converter(input_MEI_file, false, null, null, null);
                Musypher.create_dump_query();
                String nameDumpFile = "dump_" + input_MEI_file.getName().substring(0, input_MEI_file.getName().lastIndexOf(".")) + ".cypher";
                Musypher.write_query_in_file_query(nameDumpFile);
                Converter.raz();
                Musypher.close_file_query();
                System.out.println("Musypher command line: Cypher dump for propulate the graph based modelling of " + input_MEI_file.getName().toString() + " written on file " + nameDumpFile);
            }
            catch (IOException | ParserConfigurationException | SAXException e1) {
                System.out.println("Musypher command line: Failed to Parse: " + e1.getMessage());
                e1.printStackTrace();
            }
            catch (HandledException e2) {
                System.out.println("Musypher command line: Failed to Parse: " + e2.getMessage());
                e2.printStackTrace();
            }
        }
    }

    static enum TypeInputFile {
        NONE,
        FS,
        URL;

    }
}

