/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.neo4j.driver.Record;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Tester {
    File inputxmlFile;
    DocumentParser document_parser;
    NeoApi api;
    int number_measures_before;
    int number_instruments_before;
    int number_facts_before;
    int number_event_links_before;

    public Tester(File inputxmlFile, String port, String login, String psswd) throws SAXException, IOException, ParserConfigurationException {
        this.document_parser = new DocumentParser(inputxmlFile);
        this.document_parser.getDocument().getDocumentElement().normalize();
        this.api = new NeoApi("bolt://localhost:" + port, login, psswd);
        this.number_measures_before = this.api.match("MATCH (n:Measure) RETURN n").size();
        this.number_instruments_before = this.api.match("MATCH (n:Voice) RETURN n").size();
        this.number_facts_before = this.api.match("MATCH (n:Fact) RETURN n").size();
        this.number_event_links_before = this.api.match("MATCH p=()-[r:NEXT]->() RETURN p").size();
    }

    public boolean test_instruments() {
        List<Record> instruments_from_database = this.api.match("MATCH (n:Voice) RETURN n");
        NodeList instruments_from_file = this.getDocument_parser().getInstruments();
        int difference = instruments_from_database.size() - this.number_instruments_before;
        if (difference == instruments_from_file.getLength()) {
            Converter.println_log(this.getClass().toString(), "There are " + instruments_from_file.getLength() + " instruments in file and added in Database, test is OK");
            System.out.println("There are " + instruments_from_file.getLength() + " instruments in file and added in Database, test is OK");
            return true;
        }
        String message = "There are not the same amount of instrument in file and in database, test is failed";
        Converter.println_log(this.getClass().toString(), message);
        System.err.println(message);
        System.out.println(message);
        return false;
    }

    public boolean test_measures() {
        List<Record> measures_from_database = this.api.match("MATCH (n:Measure) RETURN n");
        NodeList measures_from_file = this.getDocument_parser().getMeasures();
        int difference = measures_from_database.size() - this.number_measures_before;
        if (difference == measures_from_file.getLength()) {
            Converter.println_log(this.getClass().toString(), "There are " + measures_from_file.getLength() + " measures in file and added in Database, test is OK");
            System.out.println("There are " + measures_from_file.getLength() + " measures in file and added in Database, test is OK");
            return true;
        }
        String message = "There are not the same amount of measures in file and in database, test is failed";
        Converter.println_log(this.getClass().toString(), message);
        System.err.println(message);
        System.out.println(message);
        return false;
    }

    public boolean test_facts() {
        List<Record> facts_from_database = this.api.match("MATCH (n:Fact) RETURN n");
        int number_of_facts_from_file = this.getDocument_parser().getNumberOfFacts();
        int difference = facts_from_database.size() - this.number_facts_before;
        if (difference == number_of_facts_from_file) {
            Converter.println_log(this.getClass().toString(), "There are " + number_of_facts_from_file + " facts in file and added in Database, test is OK");
            System.out.println("There are " + number_of_facts_from_file + " facts in file and added in Database, test is OK");
            return true;
        }
        String message = "There are not the same amount of facts in file and in database, test is failed";
        Converter.println_log(this.getClass().toString(), message);
        System.err.println(message);
        System.out.println(message);
        return false;
    }

    public boolean test_event_links() {
        List<Record> event_links_from_database = this.api.match("MATCH p=()-[r:NEXT]->() RETURN p");
        int number_of_event_links_from_file = this.getDocument_parser().getNumberOfFacts();
        int difference = event_links_from_database.size() - this.number_facts_before;
        if (difference == number_of_event_links_from_file) {
            Converter.println_log(this.getClass().toString(), "There are " + number_of_event_links_from_file + " event links in file and added in Database, test is OK");
            System.out.println("There are " + number_of_event_links_from_file + " event links in file and added in Database, test is OK");
            return true;
        }
        String message = "There are not the same amount of event links in file and in database, test is failed";
        Converter.println_log(this.getClass().toString(), message);
        System.out.println(message);
        System.err.println(message);
        return false;
    }

    public boolean test_converter() {
        boolean test_inst = this.test_instruments();
        boolean test_meas = this.test_measures();
        boolean test_facts = this.test_facts();
        boolean test_event_links = this.test_event_links();
        return test_inst && test_meas && test_facts && test_event_links;
    }

    public DocumentParser getDocument_parser() {
        return this.document_parser;
    }

    public void setDocument_parser(DocumentParser document_parser) {
        this.document_parser = document_parser;
    }
}

